function doPost(e) {
  try {
    var sheet = SpreadsheetApp.openById(
      "1sruNCthgFAJuO_-l9FOJ6yf78IMLYQRyjMkfpQ82ggM"
    ).getActiveSheet();
    var data = JSON.parse(e.postData.contents);

    // Insert data into the sheet
    sheet.appendRow([
      new Date(),
      data.name || "",
      data.email || "",
      data.inquiryType || "",
      data.message || "",
      "New", // Status
    ]);

    // Return success response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "success",
        message: "Your message has been sent successfully!",
      })
    ).setMimeType(ContentService.MimeType.JSON);
  } catch (error) {
    console.error("Error in Contact Form doPost:", error);

    // Return error response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "error",
        message: "Failed to send message: " + error.toString(),
      })
    ).setMimeType(ContentService.MimeType.JSON);
  }
}

/* 
Google Sheet Headers (Row 1):
Timestamp | Name | Email | Inquiry Type | Message | Status

Deploy Settings:
- Execute as: Me
- Who has access: Anyone
- Copy the deployment URL and replace YOUR_CONTACT_APPS_SCRIPT_URL in the JavaScript
*/
